% Script intrap.m
%
% used in problem 6.10 to calculate the Equivalent of Eq. (6.31) for
% trapezoidal-shaped elements. It can also be used for rectangular
% Calculates the geometric function needed to calculate the potential
% at the center of a trapez with small base Za,large base Zc and height Zb
% see Equation 6.31 and Figure 6.22b
%
% 2a=length of the small base in meters
% 2c=length of the large base in meters
% 2b=height of the trapeze in meters
% 2m=number of divisions along the length of the small base
% 2n=number of subdivisions along the height
%
disp ('Solution to problem 6.8')
disp ('Refer to solutio manual for configuration')
disp ('2a=length of the small base')
disp ('2b=height of the trapeze')
disp ('2c=length of the large base')
disp ('2m=number of divisions along the small base')
disp ('2n=number of divisions along the height')
      a=input('enter half the length of the small base in meters  --->  ')
      c=input('enter half the length of the large base in meters  --->  ')
      b=input('enter half the height of the trapeze in meters  --->  ')
      m=input('enter number of divisions along half the length of the small base  --->  ')
      n=input('enter number of subdivisions along half the height  --->  ')
% method of moments (kii) for trapezoidal shape
dx=a/m;
dy=b/n;
bb=0.0;
cc=2*b/(c-a);
dd=-b*(c+a)/(c-a);
for i=1:1000000
   yy=-b+(dy/2)+(i-1)*dy;
   if yy>(b-(dy/2)), break, end
   for j=1:1000000
      xxx=(yy-dd)/cc;
      xx=(dx/2)+(j-1)*dx;
      if xx>xxx, break, end
      bb=bb+dx*dy/sqrt(xx^2+yy^2);
   end
end
bb=bb*2;
disp('CALCULATED Fii:')
% the following prints the calculated Fii in formatter mode 4f6
fprintf('\nCalculated Fii is:  %4.6e',bb)